//////////////////////////////////////////////////////////////////////////////
//
//////////////////////////////////////////////////////////////////////////////
//
//
//
//
//
//
//////////////////////////////////////////////////////////////////////////////

#include "../inc/rom.h"


////////////////////////////////////////////////////////////////////////////////
//
////////////////////////////////////////////////////////////////////////////////
//
//
//
//
//
//
//
////////////////////////////////////////////////////////////////////////////////
UINT8	*ws_rom_load(char *path, UINT32 *romSize)
{
	char fullname[256] = ".\\logfile.log";

	FILE* m_fp = fopen( fullname, _LS("wb+") );

	if(m_fp == NULL){
		return(0);
	}

	fprintf(m_fp,"Loading rom:  0x%.2x\n",path);

	UINT8	*rom=NULL;
	s2d::s32 filepos;
	FILE *fp=fopen(path,"rb");
	if (fp==NULL)
		return(NULL);

	fseek(fp,0,SEEK_END);
	fgetpos(fp,&filepos);
	*romSize=(int)filepos;
	fseek(fp,0,SEEK_SET);
	rom=(UINT8*)malloc(*romSize);
	fread(rom,1,*romSize,fp);

	fclose(fp);	

	fprintf(m_fp,"Loaded rom:  0x%.2x\n",path);

	// close file
	fclose(m_fp);

	return(rom);
}
////////////////////////////////////////////////////////////////////////////////
//
////////////////////////////////////////////////////////////////////////////////
//
//
//
//
//
//
//
////////////////////////////////////////////////////////////////////////////////
void	ws_rom_dumpInfo(UINT8 *wsrom, UINT32 romSize)
{
	ws_romHeaderStruct		*romHeader=ws_rom_getHeader(wsrom,romSize);

	char fullname[256] = ".\\logfile.log";

	FILE* m_fp = fopen( fullname, _LS("wb+") );

	if(m_fp == NULL){
		return;
	}
	
	//fwrite(&Scene, sizeof(s32),m_fp );

	fprintf(m_fp,"rom: developper Id  0x%.2x\n",romHeader->developperId);
	fprintf(m_fp,"rom: cart Id        0x%.2x\n",romHeader->cartId);
	fprintf(m_fp,"rom: minimum system %s\n",(romHeader->minimumSupportSystem==WS_SYSTEM_MONO)?"Wonderswan mono":"Wonderswan color");
	fprintf(m_fp,"rom: size           %i Mbits\n",(romSize>>20)<<3);
	fprintf(m_fp,"rom: eeprom         ");
	switch (romHeader->eepromSize&0xf)
	{
	case WS_EEPROM_SIZE_NONE:	{ 
		fprintf(m_fp,"none\n"); 
		break; }
	case WS_EEPROM_SIZE_64k:	{ 
		fprintf(m_fp,"64 kb\n"); 
		break; }
	case WS_EEPROM_SIZE_256k:	{ 
		fprintf(m_fp,"256 kb\n"); 
		break; }
	}
	fprintf(m_fp,"rom: sram           ");
	switch (romHeader->eepromSize&0xf0)
	{
	case WS_SRAM_SIZE_NONE:	{ //fprintf(log_get(),"none\n"); 
		break; }
	case WS_SRAM_SIZE_1k:	{ //fprintf(log_get(),"1 kb\n"); 
		break; }
	case WS_SRAM_SIZE_16k:	{ //fprintf(log_get(),"16 kb\n"); 
		break; }
	case WS_SRAM_SIZE_8k:	{ //fprintf(log_get(),"8 kn\n"); 
		break; }
	}
	
	fprintf(m_fp,"rom: rtc            %s\n",(romHeader->realtimeClock)?"Yes":"None");
	fprintf(m_fp,"checksum            0x%.4x\n",romHeader->checksum);

	// close file
	fclose(m_fp);
}

////////////////////////////////////////////////////////////////////////////////
//
////////////////////////////////////////////////////////////////////////////////
//
//
//
//
//
//
//
////////////////////////////////////////////////////////////////////////////////
ws_romHeaderStruct		*ws_rom_getHeader(UINT8 *wsrom, UINT32 wsromSize)
{
	ws_romHeaderStruct *wsromHeader=(ws_romHeaderStruct *)malloc(sizeof(ws_romHeaderStruct));

	memcpy((char*)wsromHeader,(char*)wsrom+(wsromSize-10),10);
	return(wsromHeader);
}
////////////////////////////////////////////////////////////////////////////////
//
////////////////////////////////////////////////////////////////////////////////
//
//
//
//
//
//
//
////////////////////////////////////////////////////////////////////////////////
UINT32				ws_rom_sramSize(UINT8 *wsrom, UINT32 wsromSize)
{
	ws_romHeaderStruct		*romHeader=ws_rom_getHeader(wsrom,wsromSize);
	switch (romHeader->eepromSize&0xf0)
	{
	case WS_SRAM_SIZE_NONE:		return(0);
	case WS_SRAM_SIZE_1k:		return(0x400);
	case WS_SRAM_SIZE_16k:		return(0x4000);
	case WS_SRAM_SIZE_8k:		return(0x2000);
	}
	return(0);
}
////////////////////////////////////////////////////////////////////////////////
//
////////////////////////////////////////////////////////////////////////////////
//
//
//
//
//
//
//
////////////////////////////////////////////////////////////////////////////////
UINT32				ws_rom_eepromSize(UINT8 *wsrom, UINT32 wsromSize)
{
	ws_romHeaderStruct		*romHeader=ws_rom_getHeader(wsrom,wsromSize);
	switch (romHeader->eepromSize&0xf)
	{
	case WS_EEPROM_SIZE_NONE:	return(0);
	case WS_EEPROM_SIZE_64k:	return(0x10000);
	case WS_EEPROM_SIZE_256k:	return(0x40000);
	}
	return(0);
}

